/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.UnitConfiguration;
import org.apache.torque.generator.configuration.UnitConfigurationReader;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.controller.Loglevel;

public class Configuration {
    private final List<UnitDescriptor> unitDescriptors = new ArrayList<UnitDescriptor>();
    private List<UnitConfiguration> unitConfigurations;
    private ConfigurationHandlers configurationHandlers = new ConfigurationHandlers();
    private boolean read = false;

    public void addUnit(UnitDescriptor unitDescriptor) {
        if (unitDescriptor == null) {
            throw new NullPointerException("unitDescriptor must not be null.");
        }
        if (this.read) {
            throw new IllegalStateException("Configuration has already been read.");
        }
        this.unitDescriptors.add(unitDescriptor);
    }

    public void addUnits(List<UnitDescriptor> unitDescriptors) {
        for (UnitDescriptor unitDescriptor : unitDescriptors) {
            this.addUnit(unitDescriptor);
        }
    }

    public void read() throws ConfigurationException {
        if (this.read) {
            throw new IllegalStateException("Configuration has already been read.");
        }
        this.unitConfigurations = new ArrayList<UnitConfiguration>();
        Loglevel oldLoglevel = Loglevel.getCurrentLoglevel();
        for (UnitDescriptor unitDescriptor : this.unitDescriptors) {
            if (unitDescriptor.getLoglevel() != null) {
                unitDescriptor.getLoglevel().apply();
            } else {
                oldLoglevel.apply();
            }
            UnitConfigurationReader configurationReader = new UnitConfigurationReader();
            UnitConfiguration unitConfiguration = configurationReader.read(unitDescriptor, this.configurationHandlers);
            if (unitDescriptor.getLoglevel() != null) {
                unitConfiguration.setLoglevel(unitDescriptor.getLoglevel());
            }
            this.unitConfigurations.add(unitConfiguration);
        }
        this.read = true;
    }

    public List<UnitConfiguration> getUnitConfigurations() {
        if (!this.read) {
            throw new IllegalStateException("Configuration was not yet read");
        }
        return Collections.unmodifiableList(this.unitConfigurations);
    }

    public ConfigurationHandlers getConfigurationHandlers() {
        return this.configurationHandlers;
    }

    public void setConfigurationHandlers(ConfigurationHandlers configurationHandlers) {
        if (configurationHandlers == null) {
            throw new NullPointerException("configurationHandlers must not be null");
        }
        this.configurationHandlers = configurationHandlers;
    }
}

