/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema.v2;

import java.util.Map;
import org.apache.nifi.minifi.toolkit.schema.CorePropertiesSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.ConvertableSchema;

public class CorePropertiesSchemaV2
extends BaseSchema
implements ConvertableSchema<CorePropertiesSchema> {
    private static final int CONFIG_VERSION = 2;
    private String flowControllerGracefulShutdownPeriod = "10 sec";
    private String flowServiceWriteDelayInterval = "500 ms";
    private String administrativeYieldDuration = "30 sec";
    private String boredYieldDuration = "10 millis";
    private Number maxConcurrentThreads = 1;

    public CorePropertiesSchemaV2() {
    }

    public CorePropertiesSchemaV2(Map map) {
        this.flowControllerGracefulShutdownPeriod = this.getOptionalKeyAsType(map, "flow controller graceful shutdown period", String.class, "Core Properties", "10 sec");
        this.flowServiceWriteDelayInterval = this.getOptionalKeyAsType(map, "flow service write delay interval", String.class, "Core Properties", "500 ms");
        this.administrativeYieldDuration = this.getOptionalKeyAsType(map, "administrative yield duration", String.class, "Core Properties", "30 sec");
        this.boredYieldDuration = this.getOptionalKeyAsType(map, "bored yield duration", String.class, "Core Properties", "10 millis");
        this.maxConcurrentThreads = this.getOptionalKeyAsType(map, "max concurrent threads", Number.class, "Core Properties", 1);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public CorePropertiesSchema convert() {
        Map result = (Map)this.mapSupplier.get();
        result.put("flow controller graceful shutdown period", this.flowControllerGracefulShutdownPeriod);
        result.put("flow service write delay interval", this.flowServiceWriteDelayInterval);
        result.put("administrative yield duration", this.administrativeYieldDuration);
        result.put("bored yield duration", this.boredYieldDuration);
        result.put("max concurrent threads", this.maxConcurrentThreads);
        return new CorePropertiesSchema(result);
    }
}

