/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.Service;
import io.protostuff.compiler.model.ServiceMethod;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.protobuf.RootDeserializer;
import org.apache.servicecomb.foundation.protobuf.RootSerializer;
import org.apache.servicecomb.foundation.protobuf.internal.bean.BeanDescriptorManager;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.DeserializerSchemaManager;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.SerializerSchemaManager;

public class ProtoMapper {
    private final ObjectMapper jsonMapper;
    private final BeanDescriptorManager beanDescriptorManager;
    private final Proto proto;
    private final SerializerSchemaManager serializerSchemaManager;
    private final DeserializerSchemaManager deserializerSchemaManager;
    private final Map<String, JavaType> anyTypes = new ConcurrentHashMapEx();

    protected ProtoMapper(ObjectMapper jsonMapper, BeanDescriptorManager beanDescriptorManager, Proto proto) {
        this.jsonMapper = jsonMapper;
        this.beanDescriptorManager = beanDescriptorManager;
        this.proto = proto;
        this.serializerSchemaManager = new SerializerSchemaManager(this);
        this.deserializerSchemaManager = new DeserializerSchemaManager(this);
    }

    public Proto getProto() {
        return this.proto;
    }

    public SerializerSchemaManager getSerializerSchemaManager() {
        return this.serializerSchemaManager;
    }

    public DeserializerSchemaManager getDeserializerSchemaManager() {
        return this.deserializerSchemaManager;
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public BeanDescriptorManager getBeanDescriptorManager() {
        return this.beanDescriptorManager;
    }

    public Map<String, JavaType> getAnyTypes() {
        return this.anyTypes;
    }

    public void addAnyType(String canonicalName, Type type) {
        this.anyTypes.put(canonicalName, TypeFactory.defaultInstance().constructType(type));
    }

    public Message getMessageFromCanonicaName(String messageCanonicalName) {
        for (Message message : this.proto.getMessages()) {
            if (!message.getCanonicalName().equals(messageCanonicalName)) continue;
            return message;
        }
        return null;
    }

    public Message getRequestMessage(String operationId) {
        Service service = (Service)this.proto.getServices().get(0);
        ServiceMethod serviceMethod = service.getMethod(operationId);
        if (serviceMethod == null) {
            throw new IllegalArgumentException("operation not found, operation id=" + operationId);
        }
        return serviceMethod.getArgType();
    }

    public Message getResponseMessage(String operationId) {
        Service service = (Service)this.proto.getServices().get(0);
        ServiceMethod serviceMethod = service.getMethod(operationId);
        return serviceMethod.getReturnType();
    }

    public synchronized RootSerializer createRootSerializer(String shortMessageName, Type type) {
        Message message = this.proto.getMessage(shortMessageName);
        if (message == null) {
            throw new IllegalStateException("can not find proto message to create serializer, name=" + shortMessageName);
        }
        return this.createRootSerializer(message, type);
    }

    public synchronized RootSerializer createRootSerializer(Message message, Type type) {
        return this.serializerSchemaManager.createRootSerializer(message, type);
    }

    public synchronized <T> RootDeserializer<T> createRootDeserializer(String shortMessageName, Type type) {
        Message message = this.proto.getMessage(shortMessageName);
        if (message == null) {
            throw new IllegalStateException("can not find proto message to create deserializer, name=" + shortMessageName);
        }
        return this.createRootDeserializer(message, type);
    }

    public synchronized <T> RootDeserializer<T> createRootDeserializer(Message message, Type type) {
        return this.deserializerSchemaManager.createRootDeserializer(message, type);
    }

    public synchronized <T> RootDeserializer<T> createRootDeserializer(Message message, Map<String, Type> types) {
        return this.deserializerSchemaManager.createRootDeserializer(message, types);
    }
}

