/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.internal.shared.CommonDomainFinder;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.ConcatenatedGridResource;
import org.apache.sis.storage.aggregate.DimensionSelector;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.storage.aggregate.GridSliceLocator;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.aggregate.GroupByCRS;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class GroupByTransform
extends Group<GridSlice>
implements Comparator<GridSlice> {
    private final GridGeometry geometry;
    private final MathTransform gridToCRS;
    MergeStrategy strategy;
    private boolean isMosaic;
    private int searchDimension;

    GroupByTransform(GroupByCRS<GroupByTransform> parent, GridGeometry geometry, MathTransform gridToCRS) {
        super(parent);
        this.geometry = geometry;
        this.gridToCRS = gridToCRS;
        this.isMosaic = true;
    }

    @Override
    final String createName(Locale locale) {
        Vocabulary v = Vocabulary.forLocale((Locale)locale);
        StringBuffer b = new StringBuffer(v.getLabel((short)172));
        NumberFormat f = NumberFormat.getIntegerInstance(v.getLocale());
        FieldPosition p = new FieldPosition(0);
        String separator = " ";
        for (double r : this.geometry.getResolution(true)) {
            f.setMaximumFractionDigits(Math.max(DecimalFunctions.fractionDigitsForDelta((double)(r / 100.0), (boolean)false), 0));
            f.format(r, b.append(separator), p);
            separator = " \u00d7 ";
        }
        return b.toString();
    }

    final long[] integerTranslation(MathTransform crsToGrid) {
        if (this.gridToCRS.getTargetDimensions() != crsToGrid.getSourceDimensions()) {
            return null;
        }
        return CommonDomainFinder.integerTranslation((Matrix)MathTransforms.getMatrix((MathTransform)MathTransforms.concatenate((MathTransform)this.gridToCRS, (MathTransform)crsToGrid)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] findConcatenatedDimensions() {
        int dimension;
        Object[] selects;
        List list = this.members;
        synchronized (list) {
            int sliceIndex = this.members.size();
            selects = new DimensionSelector[this.geometry.getDimension()];
            dimension = selects.length;
            while (--dimension >= 0) {
                selects[dimension] = new DimensionSelector(dimension, sliceIndex);
            }
            while (--sliceIndex >= 0) {
                GridExtent extent = ((GridSlice)this.members.get((int)sliceIndex)).extentInGroup;
                int dim = selects.length;
                while (--dim >= 0) {
                    long position = extent.getMedian(dim);
                    ((DimensionSelector)selects[dim]).setSliceExtent(sliceIndex, position, extent.getSize(dim));
                }
            }
        }
        ((Stream)Arrays.stream(selects).parallel()).forEach(DimensionSelector::finish);
        Arrays.sort(selects);
        int[] dimensions = new int[selects.length];
        int count = 0;
        dimension = selects.length;
        while (--dimension >= 0) {
            Object select = selects[dimension];
            if (((DimensionSelector)select).isConstantPosition) break;
            dimensions[count++] = ((DimensionSelector)select).dimension;
            this.isMosaic &= ((DimensionSelector)select).isMosaic;
        }
        return ArraysExt.resize((int[])dimensions, (int)count);
    }

    final Resource createResource(StoreListeners parentListeners, List<SampleDimension> ranges) {
        int count = this.members.size();
        switch (count) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return ((GridSlice)this.members.get((int)0)).resource;
            }
        }
        String name = this.getName(parentListeners);
        int[] dimensions = this.findConcatenatedDimensions();
        if (dimensions.length == 0) {
            GridCoverageResource[] slices = new GridCoverageResource[this.members.size()];
            for (int i = 0; i < count; ++i) {
                slices[i] = ((GridSlice)this.members.get((int)i)).resource;
            }
            return new GroupAggregate(name, parentListeners, slices, ranges);
        }
        this.searchDimension = dimensions[0];
        if (this.isMosaic && this.strategy == null) {
            this.strategy = MergeStrategy.opaqueOverlay(null);
        }
        GridSlice[] slices = (GridSlice[])this.members.toArray(GridSlice[]::new);
        Arrays.parallelSort(slices, this);
        GridSliceLocator locator = new GridSliceLocator(this.geometry, slices, this.searchDimension);
        return new ConcatenatedGridResource(name, parentListeners, ranges, locator, this.strategy, this.processor);
    }

    @Override
    public final int compare(GridSlice o1, GridSlice o2) {
        return Long.compare(o1.extentInGroup.getLow(this.searchDimension), o2.extentInGroup.getLow(this.searchDimension));
    }
}

