/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * JAXB adapters for geometries.
 * This package regroups all adapters mapping GeoAPI interfaces to their SIS
 * implementation. We must use adapters since JAXB cannot annotate interfaces.
 * Consequently, the purpose of these adapters is to replace interfaces.
 *
 * <p>Every time JAXB tries to marshal or unmarshal an interface, the adapter
 * will be substituted to that interface.</p>
 *
 * @author  Guilhem Legal (Geomatys)
 * @author  Cullen Rombach (Image Matters)
 *
 * @see jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter
 */
@XmlSchema(elementFormDefault = XmlNsForm.QUALIFIED, namespace = Namespaces.GEX, xmlns = {
    @XmlNs(prefix = "gex", namespaceURI = Namespaces.GEX)
})
@XmlAccessorType(XmlAccessType.NONE)
package org.apache.sis.xml.bind.metadata.geometry;

import jakarta.xml.bind.annotation.XmlNs;
import jakarta.xml.bind.annotation.XmlNsForm;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import org.apache.sis.xml.Namespaces;
