/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;

public final class Characters {
    public static final char HYPHEN = '\u2010';
    public static final char SOFT_HYPHEN = '\u00ad';
    public static final char NO_BREAK_SPACE = '\u00a0';
    public static final char LINE_SEPARATOR = '\u2028';
    public static final char PARAGRAPH_SEPARATOR = '\u2029';

    private Characters() {
    }

    public static boolean isValidWKT(int c) {
        switch (c) {
            case 33: 
            case 35: 
            case 36: 
            case 64: 
            case 96: {
                return false;
            }
            case 176: {
                return true;
            }
        }
        return c >= 32 && c <= 125;
    }

    public static boolean isLineOrParagraphSeparator(int c) {
        switch (Character.getType(c)) {
            default: {
                return false;
            }
            case 13: 
            case 14: {
                return true;
            }
            case 15: 
        }
        return c == 13 || c == 10;
    }

    public static boolean isHexadecimal(int c) {
        return c >= 48 && c <= 57 || (c &= 0xFFFFFFDF) >= 65 && c <= 70;
    }

    public static boolean isSuperScript(int c) {
        switch (c) {
            case 178: 
            case 179: 
            case 185: {
                return true;
            }
            case 8305: 
            case 8306: 
            case 8307: {
                return false;
            }
        }
        return c >= 8304 && c <= 8319;
    }

    public static boolean isSubScript(int c) {
        return c >= 8320 && c <= 8334;
    }

    public static char toSuperScript(char c) {
        switch (c) {
            case '1': {
                c = (char)185;
                break;
            }
            case '2': {
                c = (char)178;
                break;
            }
            case '3': {
                c = (char)179;
                break;
            }
            case '+': {
                c = (char)8314;
                break;
            }
            case '-': {
                c = (char)8315;
                break;
            }
            case '=': {
                c = (char)8316;
                break;
            }
            case '(': {
                c = (char)8317;
                break;
            }
            case ')': {
                c = (char)8318;
                break;
            }
            case 'n': {
                c = (char)8319;
                break;
            }
            default: {
                if (c < '0' || c > '9') break;
                c = (char)(c + 8256);
            }
        }
        return c;
    }

    public static char toSubScript(char c) {
        switch (c) {
            case '+': {
                c = (char)8330;
                break;
            }
            case '-': {
                c = (char)8331;
                break;
            }
            case '=': {
                c = (char)8332;
                break;
            }
            case '(': {
                c = (char)8333;
                break;
            }
            case ')': {
                c = (char)8334;
                break;
            }
            default: {
                if (c < '0' || c > '9') break;
                c = (char)(c + 8272);
            }
        }
        return c;
    }

    public static char toNormalScript(char c) {
        return (char)Characters.toNormalScript((int)c);
    }

    public static int toNormalScript(int c) {
        switch (c) {
            case 8305: 
            case 8306: 
            case 8307: {
                break;
            }
            case 185: {
                c = 49;
                break;
            }
            case 178: {
                c = 50;
                break;
            }
            case 179: {
                c = 51;
                break;
            }
            case 8314: 
            case 8330: {
                c = 43;
                break;
            }
            case 8315: 
            case 8331: {
                c = 45;
                break;
            }
            case 8316: 
            case 8332: {
                c = 61;
                break;
            }
            case 8317: 
            case 8333: {
                c = 40;
                break;
            }
            case 8318: 
            case 8334: {
                c = 41;
                break;
            }
            case 8319: {
                c = 110;
                break;
            }
            default: {
                if (c < 8304 || c > 8329) break;
                if (c <= 8313) {
                    c -= 8256;
                    break;
                }
                if (c < 8320) break;
                c -= 8272;
            }
        }
        return c;
    }

    private static final class UnicodeIdentifier
    extends Filter {
        UnicodeIdentifier() {
            super("UNICODE_IDENTIFIER", 8390526L);
        }

        @Override
        public boolean contains(int codePoint) {
            return Character.isUnicodeIdentifierPart(codePoint) && !Character.isIdentifierIgnorable(codePoint);
        }
    }

    private static final class LettersAndDigits
    extends Filter {
        LettersAndDigits() {
            super("LETTERS_AND_DIGITS", 574L);
        }

        @Override
        public boolean contains(int codePoint) {
            return Character.isLetterOrDigit(codePoint);
        }
    }

    public static class Filter
    extends Character.Subset {
        public static final Filter LETTERS_AND_DIGITS = new LettersAndDigits();
        public static final Filter UNICODE_IDENTIFIER = new UnicodeIdentifier();
        private final long types;

        Filter(String name, long types) {
            super(name);
            this.types = types;
        }

        public boolean contains(int codePoint) {
            return (this.types & Numerics.bitmask(Character.getType(codePoint))) != 0L;
        }

        public static Filter forTypes(byte ... types) {
            int i;
            long mask = 0L;
            for (i = 0; i < types.length; ++i) {
                byte type = types[i];
                if (type < 0 || type >= 64) {
                    throw new IllegalArgumentException(Errors.format((short)59, Strings.toIndexed("types", i), type));
                }
                mask |= 1L << type;
            }
            i = 0;
            block5: while (true) {
                Filter candidate;
                switch (i) {
                    case 0: {
                        candidate = LETTERS_AND_DIGITS;
                        break;
                    }
                    case 1: {
                        candidate = UNICODE_IDENTIFIER;
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
                if (mask == candidate.types) {
                    return candidate;
                }
                ++i;
            }
            return new Filter("Filter", mask);
        }
    }
}

