/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.FeatureOperationException;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.OperationResult;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.feature.internal.shared.AttributeConvention;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.pending.jdk.JDK21;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class EnvelopeOperation
extends AbstractOperation {
    private static final long serialVersionUID = 2435142477482749321L;
    private static final ParameterDescriptorGroup EMPTY_PARAMS = EnvelopeOperation.parameters("Envelope", new ParameterDescriptor[0]);
    private final String[] attributeNames;
    final CoordinateReferenceSystem targetCRS;
    private final boolean explicitCRS;
    private final CoordinateOperation[] attributeToCRS;
    private volatile transient Set<String> dependencies;
    private final DefaultAttributeType<Envelope> resultType;

    EnvelopeOperation(Map<String, ?> identification, CoordinateReferenceSystem targetCRS, AbstractIdentifiedType[] geometryAttributes, EnvelopeOperation inheritFrom) throws FactoryException {
        super(identification);
        int i;
        this.explicitCRS = targetCRS != null;
        boolean characterizedByCRS = false;
        String defaultGeometry = null;
        boolean defaultIsFirst = true;
        LinkedHashMap<String, CoordinateReferenceSystem> names = new LinkedHashMap<String, CoordinateReferenceSystem>(4);
        for (i = 0; i < geometryAttributes.length; ++i) {
            String propertyName;
            String attributeName;
            CoordinateReferenceSystem attributeCRS = null;
            AbstractIdentifiedType property = geometryAttributes[i];
            if (property == null && inheritFrom != null) {
                CoordinateOperation op;
                propertyName = attributeName = inheritFrom.attributeNames[i];
                if (inheritFrom.attributeToCRS != null && (op = inheritFrom.attributeToCRS[i]) != null) {
                    attributeCRS = op.getSourceCRS();
                    characterizedByCRS = true;
                }
            } else {
                DefaultAttributeType at = Features.toAttribute(property).orElse(null);
                if (at == null || !Geometries.isKnownType(at.getValueClass())) continue;
                propertyName = property.getName().toString();
                attributeName = Features.getLinkTarget(property).orElse(propertyName);
                DefaultAttributeType<?> ct = at.characteristics().get("sis:crs");
                if (ct != null && CoordinateReferenceSystem.class.isAssignableFrom(ct.getValueClass())) {
                    attributeCRS = (CoordinateReferenceSystem)ct.getDefaultValue();
                    characterizedByCRS = true;
                }
            }
            if ("sis:geometry".equals(propertyName)) {
                defaultGeometry = attributeName;
                defaultIsFirst = names.isEmpty();
                if (targetCRS == null) {
                    targetCRS = attributeCRS;
                }
            }
            names.putIfAbsent(attributeName, attributeCRS);
        }
        if (!defaultIsFirst) {
            JDK21.putFirst(names, defaultGeometry, (Object)((CoordinateReferenceSystem)names.remove(defaultGeometry)));
        }
        names.remove(null);
        this.attributeNames = new String[names.size()];
        this.attributeToCRS = characterizedByCRS ? new CoordinateOperation[this.attributeNames.length] : null;
        i = 0;
        for (Map.Entry entry : names.entrySet()) {
            CoordinateReferenceSystem value;
            this.attributeNames[i] = (String)entry.getKey();
            if (characterizedByCRS && (value = (CoordinateReferenceSystem)entry.getValue()) != null) {
                if (targetCRS == null) {
                    targetCRS = value;
                }
                this.attributeToCRS[i] = CRS.findOperation((CoordinateReferenceSystem)value, (CoordinateReferenceSystem)targetCRS, null);
            }
            ++i;
        }
        this.resultType = (DefaultAttributeType)FeatureOperations.POOL.unique(new DefaultAttributeType<Object>(this.resultIdentification(identification), Envelope.class, 1, 1, null, new DefaultAttributeType[0]));
        this.targetCRS = targetCRS;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.resultType;
    }

    @Override
    public Set<String> getDependencies() {
        Set cached = this.dependencies;
        if (cached == null) {
            this.dependencies = cached = Containers.copyToImmutableSetIgnoreNull((Object[])this.attributeNames);
        }
        return cached;
    }

    @Override
    public AbstractOperation updateDependencies(Map<String, AbstractIdentifiedType> dependencies) {
        boolean foundAny = false;
        AbstractIdentifiedType[] geometryAttributes = new AbstractIdentifiedType[this.attributeNames.length];
        for (int i = 0; i < geometryAttributes.length; ++i) {
            geometryAttributes[i] = dependencies.get(this.attributeNames[i]);
            foundAny |= geometryAttributes[i] != null;
        }
        if (foundAny) {
            try {
                EnvelopeOperation op = new EnvelopeOperation(this.inherit(), this.explicitCRS ? this.targetCRS : null, geometryAttributes, this);
                if (!this.equals(op)) {
                    return (AbstractOperation)FeatureOperations.POOL.unique((Object)op);
                }
            }
            catch (FactoryException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return this;
    }

    @Override
    public Property apply(AbstractFeature feature, ParameterValueGroup parameters) {
        return new Result(feature);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.attributeNames) + Arrays.hashCode(this.attributeToCRS);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            EnvelopeOperation that = (EnvelopeOperation)obj;
            return Arrays.equals(this.attributeNames, that.attributeNames) && Arrays.equals(this.attributeToCRS, that.attributeToCRS) && Objects.equals(this.targetCRS, that.targetCRS) && this.explicitCRS == that.explicitCRS;
        }
        return false;
    }

    private final class Result
    extends OperationResult<Envelope> {
        private static final long serialVersionUID = 4900962888075807964L;

        Result(AbstractFeature feature) {
            super(EnvelopeOperation.this.resultType, feature);
        }

        @Override
        public Envelope getValue() throws FeatureOperationException {
            String[] attributeNames = EnvelopeOperation.this.attributeNames;
            GeneralEnvelope envelope = null;
            GeneralEnvelope[] deferred = null;
            boolean hasUnknownCRS = false;
            for (int i = 0; i < attributeNames.length; ++i) {
                GeneralEnvelope genv = Geometries.wrap(this.feature.getPropertyValue(attributeNames[i])).map(GeometryWrapper::getEnvelope).orElse(null);
                if (genv == null) continue;
                CoordinateReferenceSystem sourceCRS = genv.getCoordinateReferenceSystem();
                CoordinateOperation op = null;
                if (EnvelopeOperation.this.attributeToCRS != null) {
                    op = EnvelopeOperation.this.attributeToCRS[i];
                    if (sourceCRS == null) {
                        Object geomCRS;
                        AbstractAttribute<?> at = ((AbstractAttribute)this.feature.getProperty(attributeNames[i])).characteristics().get("sis:crs");
                        if (at != null && (geomCRS = at.getValue()) != null) {
                            if (!(geomCRS instanceof CoordinateReferenceSystem)) {
                                throw new FeatureOperationException(Resources.formatInternational((short)25, AttributeConvention.CRS_CHARACTERISTIC, CoordinateReferenceSystem.class, geomCRS.getClass()));
                            }
                            sourceCRS = (CoordinateReferenceSystem)geomCRS;
                        } else if (op != null) {
                            sourceCRS = op.getSourceCRS();
                        }
                        genv.setCoordinateReferenceSystem(sourceCRS);
                    }
                }
                if (sourceCRS != null && EnvelopeOperation.this.targetCRS != null) {
                    try {
                        if (op == null || sourceCRS != op.getSourceCRS()) {
                            op = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)EnvelopeOperation.this.targetCRS, null);
                        }
                        if (!op.getMathTransform().isIdentity()) {
                            genv = Envelopes.transform((CoordinateOperation)op, (Envelope)genv);
                        }
                    }
                    catch (TransformException | FactoryException e) {
                        throw new FeatureOperationException(Errors.formatInternational((short)26), (Exception)e);
                    }
                }
                hasUnknownCRS |= sourceCRS == null;
                if (envelope == null) {
                    envelope = genv;
                    continue;
                }
                if (hasUnknownCRS) {
                    throw new FeatureOperationException(Errors.formatInternational((short)189));
                }
                if (EnvelopeOperation.this.targetCRS != null) {
                    envelope.add((Envelope)genv);
                    continue;
                }
                if (deferred == null) {
                    deferred = new GeneralEnvelope[attributeNames.length];
                    deferred[0] = envelope;
                }
                deferred[i] = genv;
            }
            if (deferred == null) {
                return envelope;
            }
            try {
                return Envelopes.union(deferred);
            }
            catch (TransformException e) {
                throw new FeatureOperationException(Errors.formatInternational((short)26), (Exception)((Object)e));
            }
        }
    }
}

