/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gml;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.temporal.Temporal;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.internal.shared.XmlUtilities;

public final class TemporalAdapter
extends XmlAdapter<XMLGregorianCalendar, Temporal> {
    public Temporal unmarshal(XMLGregorianCalendar value) {
        return XmlUtilities.toTemporal(Context.current(), value);
    }

    public XMLGregorianCalendar marshal(Temporal value) {
        if (value != null) {
            try {
                return XmlUtilities.toXML(Context.current(), value);
            }
            catch (DatatypeConfigurationException e) {
                Context.warningOccured(Context.current(), TemporalAdapter.class, "marshal", e, true);
            }
        }
        return null;
    }
}

