/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.analyser;

import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.extension.apiregions.analyser.AbstractApiRegionsAnalyserTask;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public class CheckApiRegionsDependencies
extends AbstractApiRegionsAnalyserTask {
    public String getId() {
        return "api-regions-dependencies";
    }

    public String getName() {
        return "Api Regions dependecies analyser task";
    }

    @Override
    protected void execute(ApiRegions apiRegions, AnalyserTaskContext ctx) throws Exception {
        for (int i = 0; i < apiRegions.listRegions().size(); ++i) {
            for (int j = i + 1; j < apiRegions.listRegions().size(); ++j) {
                this.execute(ctx, apiRegions, apiRegions.listRegions().get(i), apiRegions.listRegions().get(j));
            }
        }
    }

    private void execute(AnalyserTaskContext ctx, ApiRegions apiRegions, ApiRegion exportingApisName, ApiRegion hidingApisName) {
        FeatureDescriptor featureDescriptor = ctx.getFeatureDescriptor();
        for (BundleDescriptor bundleDescriptor : featureDescriptor.getBundleDescriptors()) {
            for (PackageInfo packageInfo : bundleDescriptor.getExportedPackages()) {
                String exportedPackage = packageInfo.getName();
                if (exportingApisName.getExportByName(exportedPackage) == null) continue;
                if (hidingApisName.getExportByName(exportedPackage) != null) {
                    String errorMessage = String.format("Bundle '%s' (defined in feature '%s') exports package '%s' that is declared in both visible '%s' and non-visible '%s' APIs regions", bundleDescriptor.getArtifact().getId(), ctx.getFeature().getId(), exportedPackage, exportingApisName.getName(), hidingApisName.getName());
                    ctx.reportArtifactError(bundleDescriptor.getArtifact().getId(), errorMessage);
                    continue;
                }
                for (String uses : packageInfo.getUses()) {
                    if (hidingApisName.getExportByName(uses) == null) continue;
                    String errorMessage = String.format("Bundle '%s' (defined in feature '%s') exports package '%s' that is declared in the visible '%s' region, which uses package '%s' that is in the non-visible '%s' region", bundleDescriptor.getArtifact().getId(), ctx.getFeature().getId(), exportedPackage, exportingApisName.getName(), uses, hidingApisName.getName());
                    ctx.reportArtifactError(bundleDescriptor.getArtifact().getId(), errorMessage);
                }
            }
        }
    }
}

