/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers;

import jakarta.servlet.http.Cookie;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CookieSupport {
    private Map<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();

    CookieSupport() {
    }

    public void addCookie(@NotNull Cookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
    }

    @Nullable
    public Cookie getCookie(@NotNull String name) {
        return this.cookies.get(name);
    }

    @Nullable
    public Cookie[] getCookies() {
        if (this.cookies.isEmpty()) {
            return null;
        }
        return this.cookies.values().toArray(new Cookie[this.cookies.size()]);
    }

    public void reset() {
        this.cookies.clear();
    }
}

