/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.authorization.monitor.AuthorizationMonitor;
import org.apache.jackrabbit.oak.security.authorization.permission.NumEntries;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.PrincipalPermissionEntries;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.JcrAllUtil;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PermissionStoreImpl
implements PermissionStore,
PermissionConstants {
    private static final Logger log = LoggerFactory.getLogger(PermissionStoreImpl.class);
    private final String permissionRootName;
    private final RestrictionProvider restrictionProvider;
    private final AuthorizationMonitor monitor;
    private final Map<String, Tree> principalTreeMap = new HashMap<String, Tree>();
    private Tree permissionsTree;
    private PrivilegeBitsProvider bitsProvider;

    PermissionStoreImpl(@NotNull Root root, @NotNull String permissionRootName, @NotNull RestrictionProvider restrictionProvider, @NotNull AuthorizationMonitor monitor) {
        this.permissionRootName = permissionRootName;
        this.restrictionProvider = restrictionProvider;
        this.monitor = monitor;
        this.reset(root);
    }

    @Override
    public void flush(@NotNull Root root) {
        this.principalTreeMap.clear();
        this.reset(root);
    }

    private void reset(@NotNull Root root) {
        this.permissionsTree = PermissionUtil.getPermissionsRoot(root, this.permissionRootName);
        this.bitsProvider = new PrivilegeBitsProvider(root);
    }

    @Override
    @Nullable
    public Collection<PermissionEntry> load(@NotNull String principalName, @NotNull String path) {
        String name;
        Tree principalRoot = this.getPrincipalRoot(principalName);
        Collection<PermissionEntry> entries = null;
        if (principalRoot != null && principalRoot.hasChild(name = PermissionUtil.getEntryName(path))) {
            Tree child = principalRoot.getChild(name);
            if (PermissionUtil.checkACLPath(child, path)) {
                entries = this.loadPermissionEntries(path, child);
            } else {
                for (Tree node : child.getChildren()) {
                    if (!PermissionUtil.checkACLPath(node, path)) continue;
                    entries = this.loadPermissionEntries(path, node);
                    break;
                }
            }
        }
        return entries;
    }

    @Override
    @NotNull
    public NumEntries getNumEntries(@NotNull String principalName, long max) {
        Tree tree = this.getPrincipalRoot(principalName);
        if (tree == null) {
            return NumEntries.ZERO;
        }
        long l = TreeUtil.getLong(tree, "rep:numPermissions", -1L);
        return l >= 0L ? NumEntries.valueOf(l, true) : NumEntries.valueOf(tree.getChildrenCount(max), false);
    }

    @Override
    @NotNull
    public PrincipalPermissionEntries load(@NotNull String principalName) {
        long t0 = System.nanoTime();
        PrincipalPermissionEntries ret = new PrincipalPermissionEntries();
        Tree principalRoot = this.getPrincipalRoot(principalName);
        if (principalRoot != null) {
            for (Tree entryTree : principalRoot.getChildren()) {
                this.loadPermissionEntries(entryTree, ret);
            }
        }
        ret.setFullyLoaded(true);
        long t = System.nanoTime() - t0;
        this.monitor.permissionAllLoaded(t);
        log.debug("loaded {} entries in {}us for {}.", new Object[]{ret.getSize(), (double)t / 1000.0, principalName});
        return ret;
    }

    @Nullable
    private Tree getPrincipalRoot(@NotNull String principalName) {
        if (this.principalTreeMap.containsKey(principalName)) {
            return this.principalTreeMap.get(principalName);
        }
        Tree principalRoot = PermissionUtil.getPrincipalRoot(this.permissionsTree, principalName);
        if (!principalRoot.exists()) {
            principalRoot = null;
        }
        this.principalTreeMap.put(principalName, principalRoot);
        return principalRoot;
    }

    private void loadPermissionEntries(@NotNull Tree tree, @NotNull PrincipalPermissionEntries principalPermissionEntries) {
        String path = TreeUtil.getString(tree, "rep:accessControlledPath");
        if (path != null) {
            Collection<PermissionEntry> entries = principalPermissionEntries.getEntriesByPath(path);
            if (entries == null) {
                entries = new TreeSet<PermissionEntry>();
                principalPermissionEntries.putEntriesByPath(path, entries);
            }
            for (Tree child : tree.getChildren()) {
                if (child.getName().charAt(0) == 'c') {
                    this.loadPermissionEntries(child, principalPermissionEntries);
                    continue;
                }
                entries.add(this.createPermissionEntry(path, child));
            }
        } else {
            this.monitor.permissionError();
            log.error("Permission entry at '{}' without rep:accessControlledPath property.", (Object)tree.getPath());
        }
    }

    @NotNull
    private Collection<PermissionEntry> loadPermissionEntries(@NotNull String path, @NotNull Tree tree) {
        TreeSet<PermissionEntry> ret = new TreeSet<PermissionEntry>();
        for (Tree ace : tree.getChildren()) {
            if (ace.getName().charAt(0) == 'c') continue;
            ret.add(this.createPermissionEntry(path, ace));
        }
        return ret;
    }

    @NotNull
    private PermissionEntry createPermissionEntry(@NotNull String path, @NotNull Tree entryTree) {
        PropertyState ps = entryTree.getProperty("rep:privileges");
        PrivilegeBits bits = JcrAllUtil.getPrivilegeBits(ps, this.bitsProvider);
        boolean isAllow = TreeUtil.getBoolean(entryTree, "rep:isAllow");
        return new PermissionEntry(path, isAllow, Integer.parseInt(entryTree.getName()), bits, this.restrictionProvider.getPattern(path, entryTree));
    }
}

