/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.awt.Shape;
import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class RegionOfInterest
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = -8408578541189424074L;
    private final Shape geometry;
    private final CoordinateReferenceSystem crs;

    public RegionOfInterest(Shape geometry, CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureNonNull("geometry", geometry);
        ArgumentChecks.ensureDimensionMatches("crs", 2, crs);
        this.geometry = geometry;
        this.crs = crs;
    }

    public Shape toShape2D(GridGeometry target) throws TransformException {
        MathTransform2D crsToGrid;
        try {
            MathTransform tr = target.getGridToCRS(PixelInCell.CELL_CENTER).inverse();
            if (this.crs != null && target.isDefined(1)) {
                CoordinateOperation op = CRS.findOperation(this.crs, target.getCoordinateReferenceSystem(), target.getGeographicExtent().orElse(null));
                tr = MathTransforms.concatenate(op.getMathTransform(), tr);
            }
            crsToGrid = MathTransforms.bidimensional(tr);
        }
        catch (IllegalArgumentException | FactoryException e) {
            throw new TransformException(null, e);
        }
        return crsToGrid.createTransformedShape(this.geometry);
    }

    @Override
    public final boolean equals(Object other) {
        return this.equals(other, ComparisonMode.STRICT);
    }

    @Override
    public boolean equals(Object other, ComparisonMode mode) {
        if (other instanceof RegionOfInterest) {
            RegionOfInterest that = (RegionOfInterest)other;
            if (mode != ComparisonMode.STRICT || other.getClass() == this.getClass()) {
                return this.geometry.equals(that.geometry) && Utilities.deepEquals(this.crs, that.crs, mode);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.geometry.hashCode() + Objects.hashCode(this.crs);
    }
}

