/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.jsp.JspFactory;
import java.io.IOException;
import java.util.Set;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TldCache;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.servlet.TldScanner;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.xml.sax.SAXException;

public class JasperInitializer
implements ServletContainerInitializer {
    private static final String MSG = "org.apache.jasper.servlet.JasperInitializer";
    private final Log log = LogFactory.getLog(JasperInitializer.class);

    public void onStartup(Set<Class<?>> types, ServletContext context) throws ServletException {
        JspFactory factory;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)Localizer.getMessage("org.apache.jasper.servlet.JasperInitializer.onStartup", context.getServletContextName()));
        }
        if (context.getAttribute(InstanceManager.class.getName()) == null) {
            context.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
        }
        boolean validate = Boolean.parseBoolean(context.getInitParameter("org.apache.jasper.XML_VALIDATE_TLD"));
        String blockExternalString = context.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
        boolean blockExternal = blockExternalString == null ? true : Boolean.parseBoolean(blockExternalString);
        TldScanner scanner = this.newTldScanner(context, true, validate, blockExternal);
        try {
            scanner.scan();
        }
        catch (IOException | SAXException e) {
            throw new ServletException((Throwable)e);
        }
        for (String listener : scanner.getListeners()) {
            context.addListener(listener);
        }
        context.setAttribute(TldCache.SERVLET_CONTEXT_ATTRIBUTE_NAME, (Object)new TldCache(context, scanner.getUriTldResourcePathMap(), scanner.getTldResourcePathTaglibXmlMap()));
        String poolSizeValue = context.getInitParameter("org.apache.jasper.runtime.JspFactoryImpl.POOL_SIZE");
        int poolSize = 8;
        if (poolSizeValue != null) {
            try {
                poolSize = Integer.parseInt(poolSizeValue);
            }
            catch (NumberFormatException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if ((factory = JspFactory.getDefaultFactory()) instanceof JspFactoryImpl) {
            ((JspFactoryImpl)factory).setPoolSize(poolSize);
        }
    }

    protected TldScanner newTldScanner(ServletContext context, boolean namespaceAware, boolean validate, boolean blockExternal) {
        return new TldScanner(context, namespaceAware, validate, blockExternal);
    }

    static {
        JspFactoryImpl factory = new JspFactoryImpl();
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory(factory);
        }
    }
}

